/*	aspect ratio of this image is 1.24
	you can use the following sizes:
	cmd://+w300 +h372 +a0.3 +r2 +am1
	cmd://+w450 +h558 +a0.3 +r3 +am1
	cmd://+w600 +h744 +a0.2 +r2 +am2
	cmd://+w900 +h1116 +a0.1 +r4 +am1
*/

/*******************************************************************

  modifications:

    - 03-27-2003:
        Christoph Hormann: added water
                           added radiosity
                           added some dummy shapes
                           changed scale
                           changed light
                           changed sky

    - 03-27-2003
        Matti Karnaattu:   changed sky colors to match more with
                             original image
                           added sky.inc for light adjustments
                           
    - 03-28-2003
        Gena Obukhov:      added House1

    - 04-01-2003
        Bob Hughes:        added building front (to St. Paul's)
                           changed lighting, sky, some textures
                           moved buildings (houses) a little
                           scaled St. Paul's down and moved closer by half
                           added clouds (not very usable)
    

*******************************************************************/

#version 3.5;

/************************************* Flags ****************************************/
#declare showDome = 1;
#declare showHouse1 = 1;
#declare showEntrance = 1;

#declare showWater = 1;
#declare showSky = 1;
#declare showClouds = 0; // shadows cause much slower render-time, impractical

#declare showTestObjects1 = 1;
#declare showTestObjects2 = 1;

#declare use_Rad = true;
#declare use_area_light = false;


// Sun flags 
#declare useSun = 1;
#declare sunZenithAngle = 30;             // 0 - 90
#declare sunAzimuthAngle = 75; // changed // 0 is north (direction <0, 0, 1>)
#declare sunLightColor = <1.9,1.75,1.5>*1.5;  // <2.0, 1.7, 1.3> * 0.8;
#declare sunSize = 10;                    // Angle
#declare sunLightShadowMinimumDetail = 0; // 0 - 9
#declare sunLightShadowMaximumDetail = 9; // 0 - 9

// sunLightShadowMinimumDetail must be less or equal than
// sunLightShadowMaximumDetail. If sunLightShadowMaximumDetail is
// greater than zero then sunLightShadowMinimumDetail must be greater
// than zero.

#declare sunLightInteractWithMedia = false;
#declare sunPhotonsRefraction = off;
#declare sunPhotonsReflection = off;
#declare sunPhotonsAreaLight = off;


/********************************* global_settings **********************************/

global_settings {
   max_trace_level 10
  // assumed_gamma 1 // commented

   #if (use_Rad)
   ambient_light -0.2 // added
     radiosity {
       pretrace_start 0.08
       pretrace_end   0.02
       count 99 // 60 // changed

       nearest_count 5
       error_bound 0.9 // 1.0 // changed
       recursion_limit 3 // 1 // changed

       low_error_factor 0.5
       gray_threshold 0.2 // 0.0 // changed
       minimum_reuse 0.015
       brightness 1.2 // 0.6 // changed

       normal on
       media on
     }
   #end
}

#if (use_Rad)
  #default { finish { ambient 0 } }
#end


/************************************* Camera ***************************************/
camera {
    location <0, 2, -60>
    right x*image_width/image_height
    up y
    look_at <0, 8, 0>
    angle 24
}


/************************************* Lights ***************************************/
#if(useSun)
	#include "sun.inc"
#else
	light_source {
		<10, 8, 3>*10000
		color rgb <1.9,1.75,1.5> // <2.0, 1.6, 1.3>*0.8 // changed

		#if (use_area_light)
			area_light 200*x 200*y  3,3
			adaptive 1 // added
			jitter orient circular
		#end
	}	
#end


/*********************************** Test Objects ***********************************/
#if(showTestObjects1)
	// sphere{<0, 1, 0>, 1 pigment{color rgb<1, 0, 0>}} // commented

union {
  box { <-1, -2, -12>, <5, 0.2, 12> }
  box { <4, -2, -10>, <8, 8, 10> }
  box { <4, -2, 10>, <8, 8.75, 20> } // added
  box { <4, -2, 20>, <8, 7.75, 35> } // added
  box { <4, -2, 35>, <8, 7.25, 50> } // added
  box { <4, -2, 50>, <8, 8.25, 100> } // added
  rotate 4*y // -4 // changed
  translate <3, 0, -35> // changed?

  texture {
    pigment { color rgb <.75,.7,.6> } // changed?
    finish { ambient 0.15 diffuse 0.5 } // changed?
  }
}

#end


/*************************************** Dome ***************************************/
union {

#if(showDome)
	#include "colors.inc"
	#include "glass_old.inc"
	#include "metals.inc"
	#include "Stpaul.inc"

	object{StPauls scale 0.035}
#end

// added
#if(showEntrance)
	#include "entrance.inc"
	object {Entrance}
#end

 scale .5 rotate -35*y translate <-12, 60, 420>/2 // changed
}

/**************************************** Sky ***************************************/
#if(showSky)

/*
sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.00 rgb <0.96,0.95,0.91>*0.9]
      [0.07 rgb <0.72,0.8,0.92>*0.9]
      [0.20 rgb <0.45,0.58,0.8>*0.85]
      [0.37 rgb <0.26,0.43,0.72>*0.56]
    }
  }
}*/

sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 rgb <212, 191, 189> / 255]       
      [0.03 rgb <189, 226, 255> / 255] // <176, 226, 255>
      [0.15 rgb <  63, 136, 212> / 255]
      [0.5 rgb <  15, 112, 191> / 255] // <  0, 104, 139>
      [0.5 rgb 0]
    }
    scale 2
  }
}

// fog added
fog {
	fog_type 2
	distance 700
	color <.6,.75,.9>
	fog_alt 30
	fog_offset 0
}

#if(showClouds)
#declare ClearSky=pigment {rgbf 1}

#declare CloudySky=pigment {
	bumps
	color_map {
		[0 rgbf <1,1,1,0>]
		[0.5 rgbf <1,1,1,0.1>]
		[0.8 rgbf <1,1,1,0.9>]
		[0.9 rgbf 1]
	}
	turbulence 0.1 scale 0.1
}

// clouds added
sphere {
	-5000*y,6000
	pigment {
		granite
		pigment_map {
			[0.3 ClearSky]
			[0.5 CloudySky]
		}
		frequency 1 scale 300
	}
	finish {
		ambient 0.75 diffuse 0.9
	}
 hollow
}
#end

#end


/*************************************** Water **************************************/
#if(showWater)
  #include "water.inc"
#end 


/********************************* Houses. Left Side ********************************/ 
union {
	#if(showHouse1)
		#include "house1.inc"
		object {House1 scale 10}
	#end
	
	#if(showTestObjects2)
		union {
  			box { <0, -2, 0>, <4, 8, 4> translate <-4.4, 0, 0.4>}
  			box { <0, -2, 0>, <4, 5, 4> translate <5.2, 0, 0.5>}
  			box { <0, -2, 0>, <5, 7, 4> translate <9.2, 0, 0.3>}
  			box { <0, -2, 0>, <5, 6, 4> translate <15, 0, 0.3>} // added
  			box { <0, -2, 0>, <5, 7, 4> translate <22, 0, 0.3>} // added
  			box { <0, -2, 0>, <4.5, 6.5, 4> translate <26, 0, 0.3>} // added

  			texture {
    			pigment { color rgb<0.7, 0.67, 0.6> }
    			finish { ambient 0 diffuse 0.4 }
  			}
		}
	#end
	
	rotate -y*82 // 78 // changed
	translate <-5.5, 0, -28> // changed?
}

